Attribute VB_Name = "GMCOM"

' Delcarations
Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (pDst As Any, pSrc As Any, ByVal ByteLen As Long)
Public Declare Function lstrlenA Lib "kernel32" (ByVal lpString As Long) As Long

' gmcom.dll
Declare Function load_mem Lib "gmcom.dll" Alias "g_load_mem" (ByVal fields As String) As Long
Declare Function load_file Lib "gmcom.dll" Alias "g_load_file" (ByVal fields As String) As Long
Declare Function send_messages Lib "gmcom.dll" Alias "g_send_messages" () As Long
Declare Function get_error_description Lib "gmcom.dll" Alias "g_get_error_description" () As Long
Declare Function get_stats Lib "gmcom.dll" Alias "g_get_stats" () As Long
Declare Function get_summary Lib "gmcom.dll" Alias "g_get_summary" () As Long
Declare Function get_successful_sends Lib "gmcom.dll" Alias "g_get_successful_sends" () As Long
Declare Function get_failed_sends Lib "gmcom.dll" Alias "g_get_failed_sends" () As Long


' Perform a mailing
Private Function SendMessages(filename As String)

Dim summary As String
Dim status As Long

status = load_file(filename)

status = send_messages()

summary = LPSTRtoBSTR(get_error_description())

If status <> 0 Then
        summary = summary + "Successful Sends: " + Format(get_successful_sends()) + vbCrLf _
        + "Failed Sends: " + Format(get_failed_sends()) + vbCrLf _
        + LPSTRtoBSTR(get_summary()) _
        + LPSTRtoBSTR(get_stats())
End If

End Function


' Helper Functions


' Taken from: Win32 API Programming with Visual Basic by Steven Roman, Copyright 1999, O'Reilly & Associates
Function LPSTRtoBSTR(ByVal lpsz As Long) As String

' Input: a valid LPSTR pointer lpsz
' Output: a sBSTR with the same character array

Dim cChars As Long

' Get number of characters in lpsz
cChars = lstrlenA(lpsz)

' Initialize string
LPSTRtoBSTR = String$(cChars, 0)

' Copy string
CopyMemory ByVal StrPtr(LPSTRtoBSTR), ByVal lpsz, cChars

' Convert to Unicode
LPSTRtoBSTR = Trim0(StrConv(LPSTRtoBSTR, vbUnicode))

End Function


' Taken from: Win32 API Programming with Visual Basic by Steven Roman, Copyright 1999, O'Reilly & Associates
Public Function Trim0(sName As String) As String
   ' Right trim string at first null.
   Dim x As Integer
   x = InStr(sName, vbNullChar)
   If x > 0 Then Trim0 = Left$(sName, x - 1) Else Trim0 = sName
End Function


